// SoftBaugh ES449 Demonstration Program
// Copyright (c) 2002, 2003 Rowley Associates Limited
//
// Toggles the D2 LED attached to P1.0 on the ES449 under interrupt control.
// If you are powering the MSP430 from the JTAG interface then J17 (IMSP) must
// be present for the LED to toggle.

#include <msp430x44x.h>

  .code
  
reset:
   mov.w #0x210, sp
   mov.w #WDTPW + WDTHOLD, &WDTCTL   // Stop watchdog.
   mov.w #TASSEL0+TACLR, &TACTL      // Drive off ACLK.
   mov.w #CCIE, &CCTL0               // Enable CCR0 interrupt.
   mov.w #16384, &CCR0               // Set timer value.
   bis.b #0x01, &P1DIR               // P1.0 to output.
   bis.w #MC1, &TACTL                // Start Timer_A in continuous mode.
   eint
L0 bis.w #CPUOFF, sr                 // Put the CPU into a comatose state.
   jmp L0

timera_isr:
   xor.b #0x01, &P1OUT               // Toggle LED
   add.w #16384, &CCR0               // Schedule next interrupt.
   reti

   .vectors
   .keep
   org  TIMERA0_VECTOR
   dw   timera_isr
   org  RESET_VECTOR
   dw   reset

