//******************************************************************************
//  MSP-FET430P140 Demo - USART1 UART 19200 Echo ISR, XT2 HF XTAL SMCLK
//
//  Description; This program will echo a received character, RX interrupt 
//  service used. XT2 oscillator used in this example.
//  ACLK = MCLK = SMCLK = UCLK1 = XT2 = 8MHz
//  Baud rate divider with 8Mhz XTAL @19200 = 8MHz/19200 = 416.66 ~ 417 (01A0h)
//  //*An external 8MHz XTAL on X2IN X2OUT is required for ACLK*//	  
//
//               MSP430F149
//            -----------------
//        /|\|             X2IN|-  
//         | |                 | 8Mhz  
//         --|RST         X2OUT|-
//           |                 |
//           |             P3.6|------------>
//           |                 | 19200 - 8N1 
//           |             P3.7|<------------
//
//       
//  M. Buccini
//  Texas Instruments, Inc
//  February 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include <msp430x14x.h>

void main(void)
{
  unsigned int i;
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT

  BCSCTL1 &= ~XT2OFF;                   // XT2on

  do 
  {
  IFG1 &= ~OFIFG;                       // Clear OSCFault flag
  for (i = 0xFF; i > 0; i--);           // Time for flag to set
  }
  while ((IFG1 & OFIFG) != 0);          // OSCFault flag still set?                

  BCSCTL2 |= SELM1+SELS;                // MCLK = SMCLK = XT2 (safe)

  UCTL1 = CHAR;                         // 8-bit character
  UTCTL1 = SSEL1;                       // UCLK = SMCLK
  UBR01 = 0xA0;                         // 8Mhz/19200 ~ 417
  UBR11 = 0x01;                         //
  UMCTL1 = 0x00;                        // no modulation
  ME2 |= UTXE1 + URXE1;                 // Enable USART1 TXD/RXD
  IE2 |= URXIE1;                        // Enable USART1 RX interrupt
  P3SEL |= 0xC0;                        // P3.6,7 = USART1 option select
  P3DIR |= 0x20;                        // P3.6 = output direction
  _EINT();                              // Enable interrupts
  
  for (;;);                             // Do nothing
}

void usart1_rx (void) __interrupt[UART1RX_VECTOR] 
{
  while ((IFG2 & UTXIFG1) == 0);        // USART1 TX buffer ready?
  TXBUF1 = RXBUF1;                      // RXBUF1 to TXBUF1
}
