//******************************************************************************
//  MSP-FET430P120 Demo - WDT Toggle P1.0 Interval overflow ISR, DCO SMCLK 
//
//  Description; Toggle P1.0 using software timed by the WDT ISR. Toggle rate 
//  is approximately 30ms based on default ~ 800khz DCO/SMCLK clock source 
//  used in this example for the WDT.  
//  ACLK = n/a, MCLK = SMCLK = default DCO ~ 800k
//
//		 MSP430F123(2)
//             -----------------
//         /|\|              XIN|-  
//          | |                 |
//          --|RST          XOUT|-
//            |                 |
//            |             P1.0|-->LED
//
//  M.Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include  <msp430x12x.h>

void main(void)
{ 
  WDTCTL = WDT_MDLY_32;                 // Set Watchdog Timer interval to ~30ms
  IE1 |= WDTIE;                         // Enable WDT interrupt
  P1DIR |= 0x01;                        // Set P1.0 to output direction
  _EINT();                              // Enable interrupts
  
  for (;;)                              
  {
    _BIS_SR(CPUOFF);                    // Enter LPM0
    _NOP();                             // Required only for C-spy
  }
}

// Watchdog Timer interrupt service routine
void watchdog_timer(void) __interrupt[WDT_VECTOR] 
{
  P1OUT ^= 0x01;                        // Toggle P1.0 using exclusive-OR
}

