// D437V example of using the ADC12 and LCD modules.
// The input is A7, the potentiometer.  Twiddling the pot will
// change the display on the LCD.

#include <msp430x43x.h>
#include <In430.h>
#include <string.h>
#include "vi322.h"

static int seconds;
static int minutes;

void
main(void)
{
  // Stop watchdog timer.
  WDTCTL = WDTHOLD + WDTPW;
  
  // Set port functions.
  P2SEL = 0xc0;
  P3SEL = 0xff;
  P4SEL = 0xff;
  P5SEL = 0x03;
  
  // Set up basic timer for LCD operation.
  BTCTL = 0x24;

  // Set up LCD as static mode, 40 segment drive lines.
  LCDCTL = 0xe5;

  // Clear LCD.
  memset(&LCDM1, 0, 20);
  
  // Enable basic timer interrupts.
  IE2 |= 0x80;
                
  // Let interrupt processing commence.
  _EINT();
  
  // All processing is done in the interrupt handlers.
  // Enter low power mode 0 and, if we come out of it,
  // go back.
  for (;;)
    {
      _BIS_SR(LPM0_bits);
    }
}

// Interrupt routine basic timer.
void
basic_timer_interrupt(void) __interrupt[BASICTIMER_VECTOR]
{
  static char state = 0;
  state = (state+1) & 3;
  
  // Flash colons.
  if (state & 1)
    vi_322_segment_toggle(SEGMENT_COLON);
  
  if (state == 1)
    {
      ++seconds;
      if (seconds == 60)
        {
          seconds = 0;
          ++minutes;
          if (minutes > 19)
            minutes = 19;
        }
      vi_322_show_digit(seconds % 10, 0);
      vi_322_show_digit(seconds / 10, 1);
      vi_322_show_digit(minutes % 10, 2);
      if (minutes >= 10)
        vi_322_segment_on(SEGMENT_LEADING_1);
      else
        vi_322_segment_off(SEGMENT_LEADING_1);
    }
}

