// Rowley MSP430 C Compiler, runtime support.
//
// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef __inmsp_H
#define __inmsp_H

// Swap byte order within a word
#pragma intrinsic(__swap_bytes)
unsigned __swap_bytes(unsigned);

// Swap word order within a long
#pragma intrinsic(__swap_words)
unsigned long __swap_words(unsigned long);

// Swap byte order within a long
#pragma intrinsic(__swap_long_bytes)
unsigned long __swap_long_bytes(unsigned long);

// Reverse order of bits in a char
#pragma intrinsic(__bit_reverse_char)
unsigned char __bit_reverse_char(unsigned char);

// Reverse order of bits in a short
#pragma intrinsic(__bit_reverse_short)
unsigned short __bit_reverse_short(unsigned int);

// Reverse order of bits in a long
#pragma intrinsic(__bit_reverse_long)
unsigned long __bit_reverse_long(unsigned long);

// Reverse order of bits in a long long
#pragma intrinsic(__bit_reverse_long_long)
unsigned long long __bit_reverse_long_long(unsigned long long);

// Count leading zeros in a char
#pragma intrinsic(__bit_count_leading_zeros_char)
int __bit_count_leading_zeros_char(unsigned char);

// Count leading zeros in a short
#pragma intrinsic(__bit_count_leading_zeros_short)
int __bit_count_leading_zeros_short(unsigned short);

// Count leading zeros in a long
#pragma intrinsic(__bit_count_leading_zeros_long)
int __bit_count_leading_zeros_long(unsigned long);

// Count leading zeros in a long long
#pragma intrinsic(__bit_count_leading_zeros_long_long)
int __bit_count_leading_zeros_long_long(unsigned long long);

// Set bits in status register and return original status register
#pragma intrinsic(__bis_SR_register)
unsigned __bis_SR_register(unsigned);

// Clear bits in status register and return original status register
#pragma intrinsic(__bic_SR_register)
unsigned __bic_SR_register(unsigned);

// Set bits in stacked IRQ status register and return original IRQ status register
#pragma intrinsic(__bis_SR_register_on_exit)
unsigned __bis_SR_register_on_exit(unsigned);

// Clear bits in stacked IRQ status register and return original IRQ status register
#pragma intrinsic(__bic_SR_register_on_exit)
unsigned __bic_SR_register_on_exit(unsigned);

// Disable interrupts and return original status register
#define __disable_interrupt()  __bic_SR_register(8)

// Enable interrupts and return original status register
#define __enable_interrupt()  __bis_SR_register(8)

// Restore interrupts.
#define __set_interrupt(x)  __set_register(2, (x))

// Insert op into code sequence
#pragma intrinsic(__insert_opcode)
void __insert_opcode(const unsigned op);

// Insert a NOP to code sequence.
#define __no_operation() __insert_opcode(0x4303)

// Decimal add two BCD integers
#pragma intrinsic(__bcd_add_short)
unsigned __bcd_add_short(unsigned, unsigned);

// Decimal add two BCD long integers
#pragma intrinsic(__bcd_add_long)
unsigned long __bcd_add_long(unsigned long, unsigned long);

// Decimal add two BCD long long integers
#pragma intrinsic(__bcd_add_long_long)
unsigned long long __bcd_add_long_long(unsigned long long, unsigned long long);

// Decimal subtract two BCD integers
#pragma intrinsic(__bcd_subtract_short)
unsigned __bcd_subtract_short(unsigned, unsigned);

// Decimal subtract two BCD long integers
#pragma intrinsic(__bcd_subtract_long)
unsigned long __bcd_subtract_long(unsigned long, unsigned long);

// Decimal subtract two BCD long long integers
#pragma intrinsic(__bcd_subtract_long_long)
unsigned long long __bcd_subtract_long_long(unsigned long long, unsigned long long);

// Decimal negate a BCD integer
#pragma intrinsic(__bcd_negate_short)
unsigned __bcd_negate_short(unsigned);

// Decimal negate a BCD long integer
#pragma intrinsic(__bcd_negate_long)
unsigned long __bcd_negate_long(unsigned long);

// Decimal negate a BCD long long integer
#pragma intrinsic(__bcd_negate_long_long)
unsigned long long __bcd_negate_long_long(unsigned long long);

// Delay for the given number of cycles.
#pragma intrinsic(__delay_cycles)
void __delay_cycles(unsigned long long);

// Set a register
#pragma intrinsic(__set_register)
void __set_register(unsigned, unsigned);

// Get a register
#pragma intrinsic(__get_register)
unsigned __get_register(unsigned);

#endif
