
/*
  saved stack      
      saved pc
      saved sr
      saved r15
      ....

  sp->saved r4
*/

#include <msp430.h>

	.text
	.code
	.align 0

        .public _ctl_private_init_registers  
	.public _ctl_private_switch_context        
        .public _ctl_private_switch_isr_context
        .public _ctl_private_isr_return
        .public _ctl_global_interrupts_set

// void 
// ctl_private_init_registers(Task *t,                     -- r15
//                            void (*entrypoint)(void *),  -- r14
//                            void *parameter,             -- r13        
//                            void (*exitpoint)(void))     -- r12   

_ctl_private_init_registers:                          
        push.w  R11
        push.w  R10
        // *(--task->stack_pointer) = exitpoint
        sub.w  #2, 0(r15)
        mov.w  @r15, r10
        mov.w  r12, 0(r10)
        // *(--task->stack_pointer) = entrypoint
        sub.w  #2, 0(r15)
        mov.w  @r15, r10
        mov.w  r14, 0(r10)
        // *(--task->stack_pointer) = GIE;
        sub.w  #2, 0(r15)
        mov.w  @r15, r10
        mov.w  #8, 0(r10)
        // *(--task->stack_pointer) = parameter
        sub.w   #2, 0(r15)
        mov.w   @r15, r10
        mov.w   r13, 0(r10)
        // for (i=14;i!=3;i--) *(--task->stack_pointer)=i
        mov.w   #14, R11
LM1:
        sub.w  #2, 0(r15)
        mov.w  @r15, r10
        mov.w  r11, 0(r10)
        sub.w  #1, R11
        cmp.w  #3, R11
        jnz    LM1

        pop.w   R10
        pop.w   R11
        ret

// void ctl_private_switch_context(Task *save, Task *restore)
_ctl_private_switch_context:
        // save->stack_pointer = sp-14;
        mov.w    r1, 0(r15)
        add.w    #-28, 0(r15)

        // save current registers (PC points to L0:) to stack
        push.w   #L0        
        push.w   r2 
               
        push.w   r15
        push.w   r14
        push.w   r13
        push.w   r12
        push.w   r11     
        push.w   r10
        push.w   r9
        push.w   r8
        push.w   r7
        push.w   r6
        push.w   r5
        push.w   r4

        // sp = restore->stackPointer
        mov.w    @r14, r1
        jmp ctl_private_restore_registers_from_SP
L0:
        ret

// void _ctl_private_switch_isr_context(void *savedRegisters, Task *save, Task *restore);
_ctl_private_switch_isr_context:
        // save->stack_pointer = savedRegisters
        mov.w   r15, 0(r14)
        // sp = restore->stack_pointer
        mov.w   @r13, r1
        jmp     ctl_private_restore_registers_from_SP

// void ctl_private_isr_return(void *savedRegisters);
_ctl_private_isr_return:
        mov.w   r15, r1

ctl_private_restore_registers_from_SP:
        pop.w   r4  
        pop.w   r5
        pop.w   r6
        pop.w   r7
        pop.w   r8
        pop.w   r9
        pop.w   r10
        pop.w   r11
        pop.w   r12
        pop.w   r13
        pop.w   r14
        pop.w   r15

        bis.w   #(1<<3), 0(r1) // ensure that interrupts are enabled       
        bic.w   #0x00f0, 0(r1) // and we are in active mode
        reti          

//int ctl_global_interrupts_set(int e)
_ctl_global_interrupts_set:
        bit #(1<<3), r2
        jz L1             
        mov #1, r14
        jmp L2
L1:
        mov #0, r14
L2:
        tst r15
        jz L3
        bis #(1<<3), r2
        jmp L4
L3:
        bic #(1<<3), r2
L4:
        mov r14, r15
        ret
