// SoftBaugh B149 Demonstration Program
// Copyright (c) 2002, 2003 Rowley Associates Limited
//
// Toggles the P1.0 LED on the B149 under interrupt control.

#include <msp430x14x.h>

void
main(void)
{
  // Stop watchdog.
  WDTCTL = WDTPW + WDTHOLD;

  // Drive off ACLK.
  TACTL = TASSEL0 + TACLR;

  // Enable CCR0 interrupt.
  CCTL0 = CCIE;

  // Set timer value.
  CCR0 = 16384;

  // P1.0 set to output.
  P1DIR |= 0x01;

  // Start Timer_A in continuous mode.
  TACTL |= MC1;

  // Enable interrupts.
  _EINT();                              

  // Put the CPU into a comatose state.
  for (;;)
    {
      _BIS_SR(CPUOFF);
    }
}

// Timer A0 interrupt service routine.
void
timera_isr(void) __interrupt[TIMERA0_VECTOR]
{
  // Toggle LED.
  P1OUT ^= 0x01;

  // Schedule next interrupt.
  CCR0 += 16384;
}
