//******************************************************************************
//  MSP-FET430P440 Demo - Timer_B Toggle P5.1, TBCCR0 upmode ISR, DCO SMCLK 
//
//  Description; toggle P5.1 using using software and TB_0 ISR. Timer_B is 
//  configured in upmode, thus the timer will overflow when TBR counts to TBCCR0.  
//  In this example, CCR0 is loaded with 20000. 
//  ACLK = n/a, MCLK = SMCLK = TACLK = DCO ~ 800kHz
//
//           MSP430F449
//         ---------------
//     /|\|            XIN|-  
//      | |               |
//      --|RST        XOUT|-
//        |               |
//        |           P5.1|-->LED
//
//  M. Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include <msp430x44x.h>

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  TBCTL = TBSSEL1 + TBCLR;              // SMCLK, clear TBR
  TBCCTL0 = CCIE;                       // TBCCR0 interrupt enabled
  TBCCR0 = 20000;
  P5DIR |= 0x02;                        // Set P5.1 to output direction
  TBCTL |= MC0;                         // Start Timer_a in upmode
  _EINT();                              // Enable interrupts
 
  for (;;)                              
  {
    _BIS_SR(CPUOFF);                    // CPU off
    _NOP();                             // Required only for C-spy
  }
}

// Timer B0 interrupt service routine
void Timer_B (void) __interrupt[TIMERB0_VECTOR] 
{
  P5OUT ^= 0x02;                        // Toggle P5.1 using exclusive-OR
}

