//******************************************************************************
//  MSP-FET430P140 Demo - WDT Toggle P1.0, Interval ISR, 32kHz ACLK 
//
//  Description; Toggle P1.0 using software timed by WDT ISR. Toggle rate is 
//  exactly 250ms based on 32kHz ACLK WDT clock source.  In this example the 
//  WDT is configured to divide 32768 watch-crystal(2^15) by 2^13 with an ISR 
//  triggered @ 4Hz.  
//  ACLK = LFXT1 = 32768, MCLK = SMCLK = DCO ~ 800kHz
//  //*External watch crystal installed on XIN XOUT is required for ACLK*//	  
//
//		  MSP430F149
//             -----------------
//         /|\|              XIN|-  
//          | |                 | 32kHz
//          --|RST          XOUT|-
//            |                 |
//            |             P1.0|-->LED
//
//  M.Buccini
//  Texas Instruments, Inc
//  February 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include  <msp430x14x.h>

void main(void)
{ 
  WDTCTL = WDT_ADLY_250;                // WDT 250ms, ACLK, interval timer
  IE1 |= WDTIE;                         // Enable WDT interrupt
  P1DIR |= 0x01;                        // Set P1.0 to output direction
  _EINT();                              // Enable interrupts
  
  for (;;)                              
  {
    _BIS_SR(LPM3_bits);                 // Enter LPM3
    _NOP();                             // Required only for C-spy
  }
}

// Watchdog Timer interrupt service routine
void watchdog_timer(void) __interrupt[WDT_VECTOR] 
{
  P1OUT ^= 0x01;                        // Toggle P1.0 using exclusive-OR
}

