//******************************************************************************
//  MSP-FET430P140 Demo - BasicClock MCLK configured with HF XTAL XT2
//
//  Description; Proper selection of an external HF XTAL for MCLK is shown 
//  by first polling the OSC fault until XTAL is stable - only then is MCLK
//  sourced by XT2.  MCLK is on P5.4. 
//  ACLK = MCLK = XT2, SMCLK = DCO, 
//** HF XTAL NOT INSTALLED ON FET **//
//
//               MSP430F149
//            -----------------
//        /|\|            XT2IN|-  
//         | |                 | XTAL (455k - 8Mhz)
//         --|RST        XT2OUT|-
//           |                 |
//           |             P5.4|-->MCLK = XTAL
//
//       
//  M. Buccini
//  Texas Instruments, Inc
//  February 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include <msp430x14x.h>

void main(void)
{
  unsigned int i;
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  P5DIR |= 0x10;                        // P5.4 output direction
  P5SEL |= 0x10;                        // P5.4 = MCLK option select
  BCSCTL1 &= ~XT2OFF;                   // XT2 = HF XTAL

  do 
  {
  IFG1 &= ~OFIFG;                       // Clear OSCFault flag
  for (i = 0xFF; i > 0; i--);           // Time for flag to set
  }
  while ((IFG1 & OFIFG) != 0);          // OSCFault flag still set?                

  BCSCTL2 |= SELM1;                     // MCLK = XT2 (safe)
  
  for (;;);                             // Do nothing
}
