// Texas Instruments FET P410 Demonstration Program
// Copyright (c) 2002, 2003 Rowley Associates Limited
//
// Toggles the LED attached to P5.1 on the P410 under interrupt control.

#include <msp430x41x.h>

void
main(void)
{
  // Stop watchdog.
  WDTCTL = WDTPW + WDTHOLD;

  // Drive off SMCLK (DCO).
  TACTL = TASSEL1 + TACLR;

  // Enable CCR0 interrupt.
  CCTL0 = CCIE;

  // Set timer value.
  CCR0 = 65000;

  // P5.1 to output.
  P5DIR |= 0x02;

  // Start Timer_A in continuous mode.
  TACTL |= MC1;

  // Enable interrupts.
  _EINT();                              

  // Put the CPU into a comatose state.
  for (;;)
    {
      _BIS_SR(CPUOFF);
    }
}

// Timer A0 interrupt service routine.
void
timera_isr(void) __interrupt[TIMERA0_VECTOR]
{
  // Toggle LED.
  P5OUT ^= 0x02;

  // Schedule next interrupt.
  CCR0 += 65000;
}
