// SoftBaugh ES413 Demonstration Program
// Copyright (c) 2002, 2003 Rowley Associates Limited
//
// Flashes the message "HELLO" on the LCD under interrupt control.

#include <in430.h>
#include <msp430x41x.h>
#include <string.h>

void
main(void)
{ 
  // Turn off the watchdog.
  WDTCTL = WDTHOLD + WDTPW;

  // Set up ports.  
  P2SEL = 0xff; P3SEL = 0xff; P4SEL = 0xff; P5SEL = 0xff;

  // Set up interrupts and LCD.
  BTCTL = BT_fLCD_DIV32 + 0x24;
  LCDCTL = 0xfd;
  
  // Clear down LCD display memory.
  memset(LCDMEM, 0x00, 12);

  // Drive off ACLK.
  TACTL = TASSEL0 + TACLR;

  // Enable CCR0 interrupt.
  CCTL0 = CCIE;

  // Set timer value.
  CCR0 = 16384;

  // Start Timer_A in continuous mode.
  TACTL |= MC1;

  // Enable general interrupts.
  _EINT();

  // Put the CPU into a comatose state.
  for (;;)
    LPM3;
}

// Timer A0 interrupt service routine.
void
timera_isr(void) __interrupt[TIMERA0_VECTOR]
{
  // Flash message.
  LCDMEM[1] ^= 0x0E; LCDMEM[2] ^= 0x70;  // H
  LCDMEM[3] ^= 0x8E; LCDMEM[4] ^= 0x21;  // E
  LCDMEM[5] ^= 0x8A;                     // L
  LCDMEM[7] ^= 0x8A;                     // L
  LCDMEM[9] ^= 0x8A; LCDMEM[10] ^= 0x51; // O

  // Schedule next interrupt.
  CCR0 += 16384;
}
