// Copyright (c) 2006 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
// CTL template file to implement the timer tick using TIMERA.
//

#include <msp430.h>
#include <ctl_api.h>

// This defines the timeout period for a millisecond timer
#define MS_TIMEOUT 500   
        
static void (*timer_isr)(void);
static void (*button_pressed_isr)(void);

void ctl_board_init(void)
{
  P1DIR |= 1;  
}

void ctl_start_timer(CTL_ISR_FN_t isr)
{
  timer_isr = isr;
  TACTL = TASSEL1+TACLR;
  CCTL0 = CCIE;
  CCR0 = MS_TIMEOUT;
  TACTL |= MC0;
}

unsigned long ctl_get_ticks_per_second(void)
{
  return 0x1000;
}

void TimerA0_IRQ(void) __ctl_interrupt[TIMERA0_VECTOR]
{
  timer_isr();
  CCR0 += MS_TIMEOUT;  
}

void ctl_board_on_button_pressed(CTL_ISR_FN_t isr)
{
  button_pressed_isr = isr;
  P2IE |= 0xff; // P2 Interrupt enabled
  P2IES |= 0xff; // P2 hi/low edge
  P2IFG |= 0xff; // P2 IFG Cleared
}

void Port2_IRQ(void) __ctl_interrupt[PORT2_VECTOR]
{   
  P2IFG = 0;
  button_pressed_isr();  
}

void ctl_board_set_leds(unsigned v)
{
  if (v)
    P1OUT = 1;
  else
    P1OUT = 0;
}

                             
                                          
