// Texas Instruments December ATC Demo Board Demonstration Program
// Copyright (c) 2002, 2003 Rowley Associates Limited
//
// Flashes the message "HELLO" on the LCD under interrupt control.

#include <msp430x41x.h>
#include <string.h>

void
main(void)
{
  // Disable watchdog.
  WDTCTL = WDTPW+WDTHOLD;

  // Initialise the FLL.
  FLL_CTL0 = XCAP10PF;

  // Drive off ACLK.
  TACTL = TASSEL0 + TACLR;

  // Enable CCR0 interrupt.
  CCTL0 = CCIE;

  // Set timer value.
  CCR0 = 16384;

  // Start Timer_A in continuous mode.
  TACTL |= MC1;

  // Initialise unused ports.
  P1OUT = 0x00; P1DIR = 0xff;
  P2OUT = 0x01; P2DIR = 0xfe;
  P3OUT = 0x00; P3DIR = 0xff;
  P4OUT = 0x00; P4DIR = 0xff;
  P5OUT = 0x00; P5DIR = 0xff;
  P6OUT = 0x00; P6DIR = 0xff;

  // Enable R(LCD) + COM Lines.
  P5SEL = 0xfc;

  // Initialise LCD.
  LCDCTL = LCDON + LCD4MUX + LCDP2;  // STK LCD 4Mux, S0-S23

  // Initialise basic timer.
  // ACLK, LCD frame frequency @4Mux: 64Hz
  BTCTL = 0x33;

  // Clear down LCD display memory.
  memset(LCDMEM, 0x00, 12);

  // Enable general interrupts.
  _EINT();

  // Put the CPU into a comatose state.
  for (;;)
    LPM3;
}

// Timer A0 interrupt service routine.
void
timera_isr(void) __interrupt[TIMERA0_VECTOR]
{
  // Flash message.
  LCDMEM[6] ^= 0xBA; // H
  LCDMEM[5] ^= 0xAD; // E
  LCDMEM[4] ^= 0xA4; // L
  LCDMEM[3] ^= 0xA4; // L
  LCDMEM[2] ^= 0xB7; // O

  // Schedule next interrupt.
  CCR0 += 16384;
}
