// Olimex 449-STK Demonstration Program
// Copyright (c) 2002, 2003 Rowley Associates Limited
//
// Toggles the LED attached to P5.7 under interrupt control.

#include <msp430x44x.h>

  .code
  
reset:
   mov.w #0x210, sp
   mov.w #WDTPW + WDTHOLD, &WDTCTL   // Stop watchdog.
   mov.w #TASSEL0+TACLR, &TACTL      // Drive off ACLK.
   mov.w #CCIE, &CCTL0               // Enable CCR0 interrupt.
   mov.w #16384, &CCR0               // Set timer value.
   bis.b #0x80, &P5DIR               // P5.7 to output.
   bis.w #MC1, &TACTL                // Start Timer_A in continuous mode.
   eint
L0 bis.w #CPUOFF, sr                 // Put the CPU into a comatose state.
   jmp L0

timera_isr:
   xor.b #0x80, &P5OUT                // Toggle LED
   add.w #16384, &CCR0                // Schedule next interrupt.
   reti

   .vectors
   .keep
   org  TIMERA0_VECTOR
   dw   timera_isr
   org  RESET_VECTOR
   dw   reset

