//******************************************************************************
//  MSP-FET430x110 Demo - Timer_A Toggle P1.1 With TA0 up-downmode, HF XTAL ACLK  
//
//  Description; Toggle P1.1 using hardware TA0 output. Timer_A is configured
//  in up-downmode with CCR0 defining period, TA0 also output on P1.1. In this 
//  example, CCR0 is loaded with 250 and TA0 will toggling P.1 at TACLK/2*250.
//  Thus the ouput frequency on P1.1 will be the TACLK/1000.  No CPU or software
//  resources required.
//  MCLK = ACLK = TACLK = HF XTAL
//  As coded with TACLK = ACLK, P1.1 output frequency = HF XTAL/1000
//   
//            MSP430F1121
//         -----------------
//     /|\|              XIN|-  
//      | |                 | HF XTAL (455k - 8Mhz)
//      --|RST          XOUT|-
//        |                 |
//        |             P1.1|-->TA0 ACLK/1000
//
//  M.Buccini
//  Texas Instruments, Inc
//  February 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include <msp430x11x1.h>

void main(void)
{ 
  unsigned int i;
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  BCSCTL1 |= XTS;                       // ACLK = LFXT1 = HF XTAL

  do 
  {
  IFG1 &= ~OFIFG;                       // Clear OSCFault flag
  for (i = 0xFF; i > 0; i--);           // Time for flag to set
  }
  while ((IFG1 & OFIFG) != 0);          // OSCFault flag still set?                

  BCSCTL2 |= SELM1+SELM0;               // MCLK = LFXT1 (safe)

  TACTL = TASSEL0 + TACLR;              // ACLK, clear TAR
  CCTL0 = OUTMOD_4;                     // CCR0 toggle mode
  CCR0 = 250;
  P1DIR |= 0x02;                        // P1.1 output
  P1SEL |= 0x02;                        // P1.1 option select
  TACTL |= MC1 + MC0;                   // Start Timer_a in up-downmode
 
  for (;;)                              
  {
    _BIS_SR(CPUOFF);                    // CPU off
    _NOP();                             // Required only for C-spy
  }
}
