//******************************************************************************
//  MSP-FET430x110 Demo - Timer_A Toggle P1.0, overflow ISR, 32kHz ACLK 
//
//  Description; Toggle P1.0 using using software and the timer_A overflow ISR. 
//  In this example an ISR will trigger when TA overflows.  Inside the ISR P1.0 
//  is toggled.  Toggle rate is exactly 0.25hz.
//  ACLK = TACLK = LFXT1 = 32768, MCLK = SMCLK = DCO ~ 800k 
//  //*An external watch crystal on XIN XOUT is required for ACLK*//	  
//
//               MSP430F1121
//            -----------------
//        /|\|              XIN|-  
//         | |                 | 32kHz
//         --|RST          XOUT|-
//           |                 |
//           |             P1.0|-->LED
//
//  M.Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include  "msp430x11x1.h"

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  TACTL = TASSEL0 + TACLR + TAIE;       // ACLK, clr. TAR, interrupt
  P1DIR |= 0x01;                        // P1.0 output
  TACTL |= MC1;                         // Start Timer_a in continous
  _EINT();                              // Enable interrupts
 
  for (;;)                              
  {
    _BIS_SR(LPM3_bits);                 // Enter LPM3
    _NOP();                             // Required only for C-spy
  }
}

// Timer_A3 Interrupt Vector (TAIV) handler
void Timer_A(void) __interrupt [TIMERA1_VECTOR] 
{
  switch( TAIV )
  {
    case  2:  break;                    // CCR1 not used
    case  4:  break;                    // CCR2 not used
    case 10:  P1OUT ^= 0x01;            // overflow
              break;
  }
}

