//******************************************************************************
//  MSP-FET430P440 Demo - WDT Toggle P5.1 Interval overflow ISR, 32kHz ACLK
//
//  Description; Toggle P1.0 using software timed by WDT ISR. Toggle rate is 
//  exactly 250ms based on 32kHz ACLK WDT clock source.  In this example the 
//  WDT is configured to divide 32768 watch-crystal(2^15) by 2^13 with an ISR 
//  triggered @ 4Hz.  
//  ACLK = LFXT1 = 32768, MCLK = SMCLK = DCO
//  //*External watch crystal installed on XIN XOUT is required for ACLK*//	  
//
//		  MSP430F449
//             -----------------
//         /|\|              XIN|-  
//          | |                 | 32kHz
//          --|RST          XOUT|-
//            |                 |
//            |             P5.1|-->LED
//
//  M.Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include  <msp430x44x.h>

void main(void)
{ 
  WDTCTL = WDT_ADLY_250;                // WDT 250ms, ACLK, interval timer
  IE1 |= WDTIE;                         // Enable WDT interrupt
  FLL_CTL0 |= XCAP14PF;                 // COnfigure load caps
  P5DIR |= 0x02;                        // Set P5.1 to output direction
  _EINT();                              // Enable interrupts
  
  for (;;)                            
  {
    _BIS_SR(LPM3_bits);                 // Enter LPM3
    _NOP();                             // Required only for C-spy
  }
}

// Watchdog Timer interrupt service routine
void watchdog_timer(void) __interrupt[WDT_VECTOR] 
{
  P5OUT ^= 0x02;                        // Toggle P5.1 using exclusive-OR
}

