//******************************************************************************
//  MSP-FET430P440 Demo - Timer_B Toggle P5.1, TBCCR0 upmode ISR, 32kHz ACLK 
//
//  Description; Toggle P5.1 using software and the TB_0 ISR. Timer_B is 
//  configured in an upmode, thus the the timer will overflow when TBR counts 
//  to TBCCR0. In this example, TBCCR0 is loaded with 1000.
//  Toggle rate = 32768/(2*1000) = 16.384
//  ACLK = TBCLK = LFXT1 = 32768, MCLK = SMCLK = DCO = 32xACLK = 1.048576MHz
//  //*An external watch crystal on XIN XOUT is required for ACLK*//	  
//   
//           MSP430F449
//         ---------------
//     /|\|            XIN|-  
//      | |               | 32kHz
//      --|RST        XOUT|-
//        |               |
//        |           P5.1|-->LED
//
//  M. Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include <msp430x44x.h>

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  FLL_CTL0 |= XCAP14PF;                 // Configure load caps
  TBCTL = TBSSEL0 + TBCLR;              // ACLK, clear TBR
  TBCCTL0 = CCIE;                       // TRCCR0 interrupt enabled
  TBCCR0 = 1000;
  P5DIR |= 0x02;                        // Set P5.1 to output direction
  TBCTL |= MC0;                         // Start Timer_B in upmode
  _EINT();                              // Enable interrupts
 
  for (;;)                              
  {
    _BIS_SR(LPM3_bits);                 // Enter LPM3
    _NOP();                             // Required only for C-spy
  }
}

// Timer B0 interrupt service routine
void Timer_B (void) __interrupt[TIMERB0_VECTOR] 
{
    P5OUT ^= 0x02;                      // Toggle P5.1 using exclusive-OR
}

