//******************************************************************************
//  MSP-FET430P440 Demo - Timer_A Toggle P5.1, overflow ISR, DCO SMCLK 
//
//  Description; This program will toggle P5.1 using software and the timer_A 
//  overflow ISR. In this example an ISR will trigger when TA overflows.  
//  Inside the ISR P5.1 is toggled.  Toggle rate is 16hz using DCO frequency 
//  of 1048576 with default FLL and watch crystal.	 
//  ACLK = TACLK = 32768, MCLK = SMCLK = DCO = 1.048576MHz
//  //*An external watch crystal on XIN XOUT is required for ACLK*//	  
//  
//           MSP430F449
//         ---------------
//     /|\|            XIN|-  
//      | |               | 32kHz
//      --|RST        XOUT|-
//        |               |
//        |           P5.1|-->LED
//
//  M. Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include <msp430x44x.h>

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  FLL_CTL0 |= XCAP14PF;                 // Configure load caps
  TACTL = TASSEL1 + TACLR + TAIE;       // SMCLK, clr. TAR, interrupt
  P5DIR |= 0x02;                        // Set P5.1 to output direction
  TACTL |= MC1;                         // Start Timer_a in continous
  _EINT();                              // Enable interrupts
 
  for (;;)                              
  {
    _BIS_SR(CPUOFF);                    // CPU off
    _NOP();                             // Required only for C-spy
  }
}

// Timer_A3 Interrupt Vector (TAIV) handler
void Timer_A(void) __interrupt [TIMERA1_VECTOR] 
{
 switch( TAIV )
 {
   case  2: break;                      // CCR1 not used
   case  4: break;                      // CCR2 not used
   case 10: P5OUT ^= 0x02;              // overflow
            break;
 }
}

