//******************************************************************************
//  MSP-FET430P440 Demo - USART0 SPI Interface with HC165/164 Shift Registers
//
//  Description: Demonstrate USART0 in two-way SPI mode. Data are read from 
//  an HC165, and same data written back to the HC164.  
//  ACLK = n/a  MCLK = SMCLK = DCO ~ 800kHz,  UCLK0 = DCO/2 
//  //**SWRST** please see MSP430x4xx Users Guide for description //
//  //*USART0 control bits are in different SFR's from MSP430F14x/13x/12x*// 
//
//                           MSP430F449             
//                       -----------------
//                   /|\|              XIN|-  
//                    | |                 |     ^      HC164
//          HC165     --|RST          XOUT|-    |  -------------
//        ----------    |                 |     |-|/CLR,B       |  8
//    8  |      /LD|<---|P3.0   SIMO0/P3.1|------>|A          Qx|--\->
//   -\->|A-H   CLK|<---|P3.3/UCLK0 - P3.3|------>|CLK          |
//     |-|INH    QH|--->|P3.2/SOMI0       |       |             |    
//     |-|SER      |    |                 |       |             | 
//     - |         |    |                 |       |             |
//
//  M.Buccini
//  Texas Instruments, Inc
//  February 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include  "msp430x44x.h"

void main(void)
{
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
//  FLL_CTL0 |= XCAP14PF;                 // Configure load caps
  ME1 |= USPIE0;                        // Enable USART0 SPI mode
  UTCTL0 = CKPH+SSEL1+SSEL0+STC;        // SMCLK, 3-pin mode
  UCTL0 = CHAR+SYNC+MM;                 // 8-bit SPI Master **SWRST**
  UBR00 = 0x02;                         // UCLK/2 
  UBR10 = 0x00;                         // 0
  UMCTL0 = 0x00;                        // no modulation
  P3SEL |= 0x0E;                        // P3.1-3 SPI option select
  P3DIR |= 0x01;                        // P3.0 output direction
  _EINT();                              // Enable interrupts
  
  while (1)                             
  {
    unsigned i;
    for (i = 0xFFFF; i > 0; i--);         // Delay        
    while ((IFG1 & UTXIFG0) == 0);        // USART0 TX buffer ready?
    P3OUT &= ~0x01;                       // Latch data into 'HC165
    P3OUT |= 0x01;
    TXBUF0 = RXBUF0;                      // RXBUF0 to TXBUF0
  }
}
