//******************************************************************************
//  MSP-FET430P440 Demo - FLL+ clock, 32k xtal + HF xtal + internal DCO
//
//  Description This program demostrates using an external 32khz crystal to 
//  supply the internal ACLK, and using a high speed crystal or resonator to 
//  supply SMCLK. The MLCK for the CPU is supplied by the DCO.  The 32khz 
//  crystal connects to pins Xin and Xout. The high frequency crystal or 
//  resonator connects to pins XT2in and XT2out. The DCO clock is generated
//  internally and calibrated by the 32khz crystal. The resulting ACLK is 
//  brought out on I/O pin P1.5, SMCLK is brought out on P1.4, and MCLK is  
//  brought out on I/O pin P1.1. 
//  Note: 
//  External matching capacitors must be added for the high speed crystal or
//  resonator as required.
//
//                 MSP430F44x
//             -----------------
//        /|\ |              XIN|-  
//         |  |                 | 32kHz crystal 
//         ---|RST          XOUT|-                               
//            |                 |
//            |                 |
//            |            XT2IN|-  
//            |                 | HF XTAL or resonator (add capacitors)
//            |           XT2OUT|-                           
//            |                 | 
//            |             P1.5|--> ACLK = 32khz crystal out
//            |                 |
//            |             P1.4|--> SMCLK = high freq xtal or resonator out
//            |                 |
//            |             P1.1|--> MCLK = DCO frequency 
//            |                 |
//            |                 |
//
//  B. Merritt
//  Texas Instruments Inc.
//  February 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************
#include "msp430x44x.h"

void main(void)
{
  unsigned int i;
  
  WDTCTL = WDTPW + WDTHOLD;       // stop watchdog timer
  FLL_CTL0 = XCAP18PF;            // set load capacitance for 32k xtal
  FLL_CTL1 = FLL_CTL1 & ~XT2OFF;  // clear bit = high freq xtal on

  do                              // loop until flag is clear
  {
    FLL_CTL0 = FLL_CTL0 & ~XT2OF; // clear high freq oscillator fault flag
    for (i = 50000; i; i--);      // delay for crystal to start and FLL to lock
  }
  while (FLL_CTL0 & XT2OF);       // test high freq oscillator fault flag
  
                                  // if flag remained clear then -  
  FLL_CTL1 = SELS;                // switch SMCLK = HF xtal                 
  P1DIR = 0x32;                   // P1.1, P1.4 & P1.5 to outputs
  P1SEL = 0x32;                   // P1.1, P1.4 & P1.5 functions to output
                                  // MCLK, SMCLK & ACLK
  while(1);                       // loop in place
}  
