//******************************************************************************
//  MSP-FET430P440 Demo - ADC12, Converison of the Temperature Diode
//
//
//  This example shows how to use the intergrated temperature diode to measure
//  temperature. When the temperature diode channel (A10) is selected for 
//  conversion, the internal reference is automatically turned on as the source 
//  for the diode. Note however, that it is NOT automatically selected for the 
//  conversion.  Any available reference can be used for the conversion.  In 
//  this example, a single conversion is performed of the temperature diode.  
//  The temperature is then calculated in degrees C and F, based on the A/D 
//  conversion value. Test by setting and running to a break point at "_NOP()"
//  To view the temperature open a watch window in C-Spy and view DegC and 
//  DegF.
//
//  Note: This example does not perform a calibration on the temperature diode
//  A calibration of the temperature diode may be necessary in an application.
//  see the device datasheet for the temperature diode specification. 
//
//  M.Mitchell
//  Texas Instruments, Inc
//  January, 2002
//******************************************************************************

#include          "msp430x44x.h" // Standard Equations

static unsigned int ADCresult; 
static unsigned long int DegC, DegF;

void main(void)
{ 
  unsigned int i;
  WDTCTL = WDTPW+WDTHOLD;               // Stop watchdog timer
  ADC12CTL0 = ADC12ON+REFON+REF2_5V+SHT0_6; // Setup ADC12, ref., sampling time
  ADC12CTL1 = SHP;                      // Use sampling timer
  ADC12MCTL0 = INCH_10+SREF_1;          // Select channel A10, Vref+
  ADC12IE = 0x01;                       // Enable ADC12IFG.0

  for (i=0; i<0x3600; i++)              // Delay for reference start-up
  {
  }

  ADC12CTL0 |= ENC;                     // Enable conversions
  _EINT();                              // Enable interrupts

  while(1)
  {
    ADC12CTL0 |= ADC12SC;               // Start conversion
    _BIS_SR(LPM0_bits);                 // Enter LPM0

//  DegC = (Vsensor - 986mV)/3.55mV
//  Vsensor = (Vref)(ADCresult)/4095)
//  DegC -> ((ADCresult - 1615)*704)/4095
    DegC = ((((long)ADCresult-1615)*704)/4095);
    DegF = ((DegC * 9/5)+32);           // Calculate DegF
    _NOP();                             // SET BREAKPOINT HERE
  }
}

void ADC12ISR (void) __interrupt[ADC_VECTOR] 
{
  ADCresult = ADC12MEM0;                // Move results, IFG is cleared
  _BIC_SR_IRQ(LPM0_bits);               // Clear LPM0
}



