//******************************************************************************
//  MSP-FET430P440 Demo - ADC12, Extend Sampling Period With SHT bits
//
//  This example shows how to extend the sampling time using the sampling  
//  timer. In this example, the ADC12OSC is used to provide the sampling period 
//  and the SHT0 bits are set to extend the sampling period to 4xADC12CLKx256.  
//  A single conversion is performed on channel A0. The A/D conversion results 
//  are stored in ADC12MEM0 and are moved to 'results' upon completion of the 
//  conversion. Test by setting and running to a break point at the "_BIC..." 
//  instruction in the ISR. To view the conversion results, open a watch window 
//  in C-Spy and view 'results.'
//
//
//                MSP430F449
//             ---------------
//            |               |
//            |      A0 (P6.0)|<---- Vin
//            |               |
//
//  M.Mitchell
//  Texas Instruments, Inc
//  January, 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include          "msp430x44x.h" // Standard Equations

static unsigned int results;            // Needs to be global in this example
                                        // Otherwise, the compiler removes it
                                        // because it is not used for anything.

void main(void)
{ 
  WDTCTL = WDTPW+WDTHOLD;               // Stop watchdog timer
  P6SEL |= 0x01;                        // Enable A/D channel A0
  ADC12CTL0 = ADC12ON+SHT0_15;          // Turn on ADC12, set sampling time
  ADC12CTL1 = SHP;                      // Use sampling timer, set mode
  ADC12IE = 0x01;                       // Enable ADC12IFG.0
  ADC12CTL0 |= ENC;                     // Enable conversions
  _EINT();                              // Enable interrupts  

  while(1)
  {
  ADC12CTL0 |= ADC12SC;                 // Start conversion
  _BIS_SR(LPM0_bits);                   // Enter LPM0 
   }
}

void ADC12ISR (void) __interrupt[ADC_VECTOR] 
{
  results = ADC12MEM0;                  // Move results, IFG is cleared
  _BIC_SR_IRQ(LPM0_bits);               // Clear LPM0, SET BREAKPOINT HERE
}
