//*******************************************************************************
//  MSP-FET430P440 Demo - Software Toggle P5.1 
//
//  Description; Toggle P5.1 by xor'ing P5.1 inside of a software loop.
//  MCLK = DCO ~ 800k
//
//                MSP430F449
//             -----------------
//         /|\|              XIN|-  
//          | |                 |
//          --|RST          XOUT|-
//            |                 |
//            |             P5.1|-->LED
//
//  M.Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include  <msp430x44x.h>

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;             // Stop watchdog timer
  P5DIR |= 0x02;                        // Set P5.1 to output direction

  for (;;)                              
  {
    unsigned int i;

    P5OUT ^= 0x02;                      // Toggle P5.1 using exclusive-OR

    i = 50000;                          // Delay
    do (i--);
    while (i != 0);
  }
}
