//******************************************************************************
//  MSP-FET430P410 Demo - Timer_A Toggle P5.1, CCR0 upmode ISR, 32kHz ACLK 
//
//  Description; Toggle P5.1 using software and the TA_0 ISR. Timer_A is 
//  configured in an upmode, thus the the timer will overflow when TAR counts 
//  to CCR0. In this example, CCR0 is loaded with 1000.
//  Toggle rate = 32768/(2*1000) = 16.384
//  ACLK = TACLK = LFXT1 = 32kHz, MCLK = SMCLK = DCO = 32xACLK = 1.048576MHz 
//  //*An external watch crystal on XIN XOUT is required for ACLK*//	  
//   
//           MSP430F413
//         ---------------
//     /|\|            XIN|-  
//      | |               | 32kHz
//      --|RST        XOUT|-
//        |               |
//        |           P5.1|-->LED
//
//  M. Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include <msp430x41x.h>

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  FLL_CTL0 |= XCAP14PF;                 // Configure load caps
  TACTL = TASSEL0 + TACLR;              // ACLK, clear TAR
  CCTL0 = CCIE;                         // CCR0 interrupt enabled
  CCR0 = 1000;
  P5DIR |= 0x02;                        // Set P5.1 to output direction
  TACTL |= MC0;                         // Start Timer_a in upmode
  _EINT();                              // Enable interrupts
 
  for (;;)                              
  {
    _BIS_SR(LPM3_bits);                 // Enter LPM3
    _NOP();                             // Required only for C-spy
  }
}

// Timer A0 interrupt service routine
void Timer_A (void) __interrupt[TIMERA0_VECTOR] 
{
    P5OUT ^= 0x02;                      // Toggle P5.1 using exclusive-OR
}

