//******************************************************************************
//  MSP-FET430P410 Demo - Timer_A Toggle P5.1, overflow ISR, 32kHz ACLK 
//
//  Description; Toggle P5.1 using using software and the timer_A overflow ISR. 
//  In this example an ISR will trigger when TA overflows.  Inside the ISR P1.0 
//  is toggled.  Toggle rate is exactly 0.25hz.
//  ACLK = TACLK = LFXT1 = 32768, MCLK = SMCLK = DCO = 32xACLK 
//  Proper use of TAIV interrupt vector generator demonstrated.
//  //*An external watch crystal on XIN XOUT is required for ACLK*//	  
//
//           MSP430F413
//         ---------------
//     /|\|            XIN|-  
//      | |               | 32kHz
//      --|RST        XOUT|-
//        |               |
//        |           P1.0|-->LED
//
//  M. Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include <msp430x41x.h>

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  FLL_CTL0 |= XCAP14PF;                 // Configure load caps
  TACTL = TASSEL0 + TACLR + TAIE;       // ACLK, clr. TAR, interrupt
  P5DIR |= 0x02;                        // Set P5.1 to output direction
  TACTL |= MC1;                         // Start Timer_a in continous
  _EINT();                              // Enable interrupts
 
  for (;;)                              
  {
    _BIS_SR(LPM3_bits);                 // Enter LPM3
    _NOP();                             // Required only for C-spy
  }
}

// Timer_A3 Interrupt Vector (TAIV) handler
void Timer_A(void) __interrupt [TIMERA1_VECTOR] 
{
  switch( TAIV )
  {
    case  2:  break;                    // CCR1 not used
    case  4:  break;                    // CCR2 not used
    case 10:  P5OUT ^= 0x02;            // overflow
              break;
  }
}

