//*****************************************************************************
//  MSP-FET430P410 Demo - LCD Blink "6543210" on STK/EVK LCD 
//
//  Description; Put "6543210" on MSP-EVK430S320 LCD. 
//  ACLK = LFXT1 = 32768, MCLK = SMCLK = DCO = 32xACLK = 1.048576MHz
//  //*An external watch crystal is required on XIN/XOUT for ACLK*//	  
//
//                MSP430F413
//            -----------------
//        /|\|              XIN|-  
//         | |                 | 32kHz
//         --|RST          XOUT|-
//           |                 |
//         +-|R33          P5.1|     -----------------
//        1m |              -  |--> | + 7 6 5 4 3 2 1 |
//         +-|R23          P3.2|     -----------------
//        1m |             COM0|-----||||
//         +-|R13          COM1|------|||
//        1m |             COM2|-------||
//         +-|R03          COM3|--------|
//         | |                 |
//        Vss
//
//  M.Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//*****************************************************************************

#include  <msp430x41x.h>
char digit[10] = {
0xB7,  /* "0" LCD segments a+b+c+d+e+f */
0x12,  /* "1" */
0x8F,  /* "2" */
0x1F,  /* "3" */
0x3A,  /* "4" */
0x3D,  /* "5" */
0xBD,  /* "6" */
0x13,  /* "7" */
0xBF,  /* "8" */
0x3F   /* "9" */
};

void main(void)
{
   int i;
  WDTCTL = WDTPW + WDTHOLD;             // Stop watchdog timer
  FLL_CTL0 |= XCAP14PF;                 // Configure load caps
  LCDCTL = LCDON + LCD4MUX + LCDP2;     // STK LCD 4Mux, S0-S17
  BTCTL = BTFRFQ1;                      // STK LCD freq 
  P5SEL = 0xFC;                         // Common and Rxx all selected
       
  for (;;)                             
  {
  for (i=0; i<7; ++i)                   // Display "6543210" 
  LCDMEM[i] = digit[i];
  }
}


