//******************************************************************************
//  MSP-FET430P410 Demo - FLL Output MCLK, ACLK Using 32k XTAL and DCO 
//
//  Description; This program will output the system MCLK and ACLK.
//  ACLK = LFXT1 = 32768, MCLK = DCO = 32xACLK  1.048576MHz
//  //*An external watch crystal is required on XIN/XOUT for ACLK*//	  
//
//                MSP430F413
//            -----------------
//        /|\|              XIN|-  
//         | |                 | 32kHz
//         --|RST          XOUT|-
//           |                 |
//           |             P1.1|-->MCLK 1048576
//           |             P1.5|-->ACLK 32kHz
//
//  M.Buccini
//  Texas Instruments, Inc
//  January 2002
//******************************************************************************
#include "msp430x41x.h"

void main(void)
{
  WDTCTL = WDTPW + WDTHOLD;       // Stop watchdog timer
  FLL_CTL0 = XCAP14PF;            // Configure load caps
  
  P1DIR = 0x22;                   // P1.1 & P1.5 to output direction
  P1SEL = 0x22;                   // P1.1 & P1.5 to output MCLK & ACLK
  
  while(1);                       // Loop in place
}  
