//******************************************************************************
//  MSP-FET430P410 Demo - BasicTimer Toggle P5.1 using ISR, DCO SMCLK 
//
//  Description; This program will toggle P5.1 by xor'ing P5.1 inside of
//  a basic timer ISR. Default DCO used to clock basic timer. 
//  ACLK = n/a, MCLK = SMCLK = default DCO 
//
//		  MSP430F413
//             -----------------
//         /|\|              XIN|-  
//          | |                 |
//          --|RST          XOUT|-
//            |                 |
//            |             P5.1|-->LED
//
//  M.Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include  <msp430x41x.h>

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  IE2 |= BTIE;                          // Enable BT interrupt
  BTCTL = BTSSEL+BTIP2+BTIP1+BTIP0;       
  P5DIR |= 0x02;                        // Set P5.1 to output direction
  _EINT();                              // Enable interrupts
  
  for (;;)                              
  {
    _BIS_SR(CPUOFF);                    // Enter LPM0
    _NOP();                             // Required only for C-spy
  }
}

// Basic Timer interrupt service routine
void basic_timer(void) __interrupt[BASICTIMER_VECTOR] 
{
  P5OUT ^= 0x02;                        // Toggle P5.1 using exclusive-OR
}

