//******************************************************************************
//  MSP-FET430P140 Demo - Timer_B Toggle P1.0, TBCCR0 upmode ISR, 32kHz ACLK 
//
//  Description; Toggle P1.0 using software and the TB_0 ISR. Timer_B is 
//  configured in an upmode, thus the the timer will overflow when TBR counts 
//  to TBCCR0. In this example, TBCCR0 is loaded with 1000.
//  Toggle rate = 32768/(2*1000) = 16.384
//  ACLK = TBCLK = 32kHz, MCLK = SMCLK = DCO ~ 800k
//  //*An external watch crystal on XIN XOUT is required for ACLK*//	  
//   
//           MSP430F149
//         ---------------
//     /|\|            XIN|-  
//      | |               | 32kHz
//      --|RST        XOUT|-
//        |               |
//        |           P1.0|-->LED
//
//  M. Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include <msp430x14x.h>

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  TBCTL = TBSSEL0 + TBCLR;              // ACLK, clear TBR
  TBCCTL0 = CCIE;                       // TRCCR0 interrupt enabled
  TBCCR0 = 1000;
  P1DIR |= 0x01;                        // Set P1.0 to output direction
  TBCTL |= MC0;                         // Start Timer_B in upmode
  _EINT();                              // Enable interrupts
 
  for (;;)                              
  {
    _BIS_SR(LPM3_bits);                 // Enter LPM3
    _NOP();                             // Required only for C-spy
  }
}

// Timer B0 interrupt service routine
void Timer_B (void) __interrupt[TIMERB0_VECTOR] 
{
    P1OUT ^= 0x01;                      // Toggle P1.0 using exclusive-OR
}

