//******************************************************************************
//  MSP-FET430P140 Demo - Timer_B Toggle P1.0, overflow ISR, 32kHz ACLK 
//
//  Description; Toggle P1.0 using using software and the timer_B overflow ISR. 
//  In this example an ISR will trigger when TB overflows.  Inside the ISR P1.0 
//  is toggled.  Toggle rate is exactly 0.25hz.
//  Proper use of TBIV interrupt vector generator demonstrated.
//  ACLK = TBCLK = 32kHz, MCLK = SMCLK = DCO ~ 800k
//  //*An external watch crystal on XIN XOUT is required for ACLK*//	  
//
//           MSP430F149
//         ---------------
//     /|\|            XIN|-  
//      | |               | 32kHz
//      --|RST        XOUT|-
//        |               |
//        |           P1.0|-->LED
//
//  M. Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include <msp430x14x.h>

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  TBCTL = TBSSEL0 + TBCLR + TBIE;       // ACLK, clr. TBR, interrupt
  P1DIR |= 0x01;                        // Set P1.0 to output direction
  TBCTL |= MC1;                         // Start Timer_B in continous
  _EINT();                              // Enable interrupts
 
  for (;;)                              
  {
    _BIS_SR(LPM3_bits);                 // Enter LPM3
    _NOP();                             // Required only for C-spy
  }
}

// Timer_B7 Interrupt Vector (TBIV) handler
void Timer_B(void) __interrupt [TIMERB1_VECTOR] 
{
 switch( TBIV )
 {
   case  2: break;                      // CCR1 not used
   case  4: break;                      // CCR2 not used
   case 14: P1OUT ^= 0x01;              // overflow
           break;
  }
}

