//******************************************************************************
//  MSP-FET430P140 Demo - Timer_B Toggle P1.0, TBCCR0 upmode ISR, DCO SMCLK 
//
//  Description; toggle P1.0 using using software and TB_0 ISR. Timer_A is 
//  configured in upmode, thus the timer will overflow when TBR counts to TBCCR0.  
//  In this example, CCR0 is loaded with 20000. 
//  MCLK = SMCLK = TBCLK = default DCO 
//
//           MSP430F149
//         ---------------
//     /|\|            XIN|-  
//      | |               |
//      --|RST        XOUT|-
//        |               |
//        |           P1.0|-->LED
//
//  M. Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include <msp430x14x.h>

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  TBCTL = TBSSEL1 + TBCLR;              // SMCLK, clear TBR
  TBCCTL0 = CCIE;                       // TBCCR0 interrupt enabled
  TBCCR0 = 20000;
  P1DIR |= 0x01;                        // Set P1.0 to output direction
  TBCTL |= MC0;                         // Start Timer_a in upmode
  _EINT();                              // Enable interrupts
 
  for (;;)                              
  {
    _BIS_SR(CPUOFF);                    // CPU off
    _NOP();                             // Required only for C-spy
  }
}

// Timer B0 interrupt service routine
void Timer_B (void) __interrupt[TIMERB0_VECTOR] 
{
  P1OUT ^= 0x01;                        // Toggle P1.0 using exclusive-OR
}

