//*******************************************************************************
//  MSP-FET430P140 Demo - Timer_A PWM TA1-2 up-downmode, DCO SMCLK
//
//  Description; This program will generate a two PWM outputs on P1.2/1.3 using
//  Timer_A in an upmode.  The value in CCR0, 128, defines the period/2 and the 
//  values in CCR1 and CCR1 the duty PWM cycles.  Using ~ 800kHz SMCLK as TACLK,
//  the timer period is ~ 320us with a 75% duty cycle on P1.2 and 25% on P1.3. 
//  SMCLK = MCLK = TACLK = default DCO ~ 800kHz. 
//  As coded, the output signals TA1 on P1.2 and TA2 on P1.3 are inverted. 
//
//               MSP430F149
//            -----------------
//        /|\|              XIN|-  
//         | |                 | 
//         --|RST          XOUT|-
//           |                 |
//           |             P1.2|--> CCR1 - 75% PWM
//           |             P1.3|--> CCR2 - 25% PWM
//
//  M.Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include <msp430x14x.h>

void main(void)
{ 
  WDTCTL = WDTPW +WDTHOLD;              // Stop WDT
  TACTL = TASSEL1 + TACLR;              // SMCLK, Clear Tar
  CCR0 = 128;                           // PWM Period/2
  CCTL1 = OUTMOD_2;                     // CCR1 reset/set
  CCR1 = 64;                            // CCR1 PWM duty cycle
  CCTL2 = OUTMOD_6;                     // CCR2 reset/set
  CCR2 = 96;                            // CCR2 PWM duty cycle
  P1DIR |= 0x0C;                        // P1.2 and P1.3 output
  P1SEL |= 0x0C;                        // P1.2 and P1.3 TA1/2 otions
  TACTL |= MC1 + MC0;                   // Start Timer_A in up-down mode
  
  for (;;)                            
  {
    _BIS_SR(CPUOFF);                    // Enter LPM0
    _NOP();                             // Required only for C-spy
  }
}

