//******************************************************************************
//  MSP-FET430P140 Demo - Timer_A Toggle P1.0-3 CCRx Contmode ISR, DCO SMCLK  
//
//  Description; Use timer_A CCRx units and overflow to generate four
//  independent timing intervals. For demonstration, CCR0, CCR1 and CCR2 output
//  units are optionally selected with port pins P1.1, P1.2 and P1.3 in toggle
//  mode. As such, these pins will toggle when respective CCRx registers match
//  the TAR counter. Interrupts are also enabled with all CCRx units,
//  software loads offset to next inderval only - as long as the interval offset
//  is aded to CCRx, toggle rate is generated in hardware. Timer_A overflow ISR 
//  is used to toggle P1.0 with software.  
//  ACLK = n/a, MCLK = SMCLK = TACLK = DCO ~ 800k 
//  As coded and assumming ~ 800kHz DCO, toggle rates:
//  P1.1 = CCR0 = 800kHz/(2*200) ~ 2000Hz
//  P1.2 = CCR1 = 800kHz/(2*1000) ~ 400Hz
//  P1.3 = CCR2 = 800kHz/(2*10000) ~ 40Hz
//  P1.0 = overflow = 800kHz/(2*65536) ~ 6Hz
//  Proper use of TAIV interrupt vector generator demonstrated.   
//
//              MSP430F123(2)
//            -----------------
//        /|\|              XIN|-  
//         | |                 |
//         --|RST          XOUT|-
//           |                 |
//           |             P1.1|--> CCR0
//           |             P1.2|--> CCR1
//           |             P1.3|--> CCR2
//           |             P1.0|--> overflow/software
//
//  M.Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include  "msp430x14x.h"

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  TACTL = TASSEL1 + TACLR + TAIE;       // SMCLK, clear TAR, interrupt enabled
  CCTL0 = OUTMOD_4 + CCIE;              // CCR0 toggle, interrupt enabled
  CCTL1 = OUTMOD_4 + CCIE;              // CCR1 toggle, interrupt enabled
  CCTL2 = OUTMOD_4 + CCIE;              // CCR2 toggle, interrupt enabled
  CCR0 = 200;
  CCR1 = 1000;
  CCR2 = 10000;
  P1SEL |= 0x0E;                        // P1.1 - P1.4 option select
  P1DIR |= 0x0F;                        // P1.0 - P1.4 outputs
  TACTL |= MC1;                         // Start Timer_A in continuous mode
  _EINT();                              // Enable interrupts
 
  for (;;)                              
  {
    _BIS_SR(CPUOFF);                    // CPU off
    _NOP();                             // Required only for C-spy
  }
}

// Timer A0 interrupt service routine
void Timer_A0 (void) __interrupt[TIMERA0_VECTOR] 
{
  CCR0 += 200;                          // Add Offset to CCR0
}

// Timer_A3 Interrupt Vector (TAIV) handler
void Timer_A1(void) __interrupt [TIMERA1_VECTOR] 
{
  switch( TAIV )
  {
  case  2: CCR1 += 1000;                // Add Offset to CCR1
           break;
  case  4: CCR2 += 10000;               // Add Offset to CCR2
           break;                              
  case 10: P1OUT ^= 0x01;               // Timer_A3 overflow
           break;
 }
}

