//******************************************************************************
//  MSP-FET430P140 Demo - Timer_A Toggle P1.0, overflow ISR, DCO SMCLK 
//
//  Description; Toggle P1.0 using using software and timer_A overflow ISR. 
//  In this example an ISR will trigger when TA overflows.  Inside the TA
//  overflow ISR P1.0 is toggled.  Toggle rate is approximatlely 12hz. 
//  ACLK = n/a, MCLK = SMCLK = TACLK = DCO ~ 800k 
//  Proper use of TAIV interrupt vector generator demonstrated.
//  
//           MSP430F149
//         ---------------
//     /|\|            XIN|-  
//      | |               |
//      --|RST        XOUT|-
//        |               |
//        |           P1.0|-->LED
//
//  M. Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include <msp430x14x.h>

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  TACTL = TASSEL1 + TACLR + TAIE;       // SMCLK, clr. TAR, interrupt
  P1DIR |= 0x01;                        // P1.0 output
  TACTL |= MC1;                         // Start Timer_a in continous
  _EINT();                              // Enable interrupts
 
  for (;;)                              
  {
    _BIS_SR(CPUOFF);                    // CPU off
    _NOP();                             // Required only for C-spy
  }
}

// Timer_A3 Interrupt Vector (TAIV) handler
void Timer_A(void) __interrupt [TIMERA1_VECTOR] 
{
 switch( TAIV )
 {
   case  2: break;                      // CCR1 not used
   case  4: break;                      // CCR2 not used
   case 10: P1OUT ^= 0x01;              // overflow
            break;
 }
}

