//******************************************************************************
//  MSP-FET430P140 Demo - ADC12 Sample A0, AVcc
//
//  Description; A simple single sample is made on A0 with refernce to Avcc.  
//  Software controls pulse on ADC12SC to sample analog input signal and start 
//  conversion. ADC12  internal oscillator times conversion. ADC12BUSY flag is 
//  polled for EOC. Conversion result saved in ADC12MEM0. 
//  // For acurate conversion, bias ADC12 references per device datasheet //  
//  
//                MSP430F149
//             -----------------
//         /|\|              XIN|-  
//          | |                 |
//          --|RST          XOUT|-
//            |                 |
//  0-AVcc >--|A0               |
//
//  M.Buccini
//  Texas Instruments, Inc
//  February 2002
//******************************************************************************

#include  <msp430x14x.h>

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  ADC12CTL0 = ADC12ON;                  // ADC12ON
  P6SEL |= 0x01;                        // P6.0 ADC option select 
  
  for (;;)                              
  {
    ADC12CTL0 |= ADC12SC + ENC;         // Sampling open
    ADC12CTL0 &= ~ADC12SC;              // Sampling closed, start conversion
    while ((ADC12CTL1 & ADC12BUSY) == 1);   // ADC12BUSY?
  }
}
