//******************************************************************************
//  MSP-FET430P120 Demo - WDT Toggle P1.0, Interval Overflow ISR, 32kHz ACLK 
//
//  Description; Toggle P1.0 using software timed by the WDT ISR. In this 
//  example the WDT is clocked with ACLK which is the same as the XTAL and 
//  divided by the WDT by 512 triggering and ISR that will toggle P1.0.
//  ACLK = MCLK = LFXT1 = HF XTAL
//  //** HF XTAL REQUIRED AND NOT INSTALLED ON FET **//
//
//		 MSP430F123(2)
//             -----------------
//         /|\|              XIN|-  
//          | |                 | HF XTAL (455k - 8Mhz) 
//          --|RST          XOUT|-
//            |                 |
//            |             P1.0|-->LED
//
//  M.Buccini
//  Texas Instruments, Inc
//  February 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include  <msp430x12x.h>

void main(void)
{ 
  unsigned int i;
  WDTCTL = WDT_ADLY_16;                 // ACLK / 512, interval timer
  BCSCTL1 |= XTS;                       // ACLK = LFXT1 = HF XTAL

  do 
  {
  IFG1 &= ~OFIFG;                       // Clear OSCFault flag
  for (i = 0xFF; i > 0; i--);           // Time for flag to set
  }
  while ((IFG1 & OFIFG) != 0);          // OSCFault flag still set?                

  BCSCTL2 |= SELM1+SELM0;               // MCLK = LFXT1 (safe)
  IE1 |= WDTIE;                         // Enable WDT interrupt
  P1DIR |= 0x01;                        // Set P1.0 to output direction
  _EINT();                              // Enable interrupts
  
  for (;;)                              
  {
    _BIS_SR(LPM3_bits);                 // Enter LPM3
    _NOP();                             // Required only for C-spy
  }
}

// Watchdog Timer interrupt service routine
void watchdog_timer(void) __interrupt[WDT_VECTOR] 
{
  P1OUT ^= 0x01;                        // Toggle P1.0 using exclusive-OR
}

