//******************************************************************************
//  MSP-FET430P120 Demo - Timer_A Toggle P1.1 With TA0 upmode, DCO SMCLK  
//
//  Description; Toggle P1.1 using hardware TA0 output. Timer_A is configured
//  in upmode with CCR0 defining period, TA0 also output on P1.1. In this 
//  example, CCR0 is loaded with 500 and TA0 will toggling P.1 at TACLK/500.
//  Thus the ouput frequency on P1.1 will be the TACLK/1000.  No CPU or software
//  resources required.
//  SMCLK = MCLK = TACLK = default DCO ~ 800kHz
//  As coded with TACLK = SMCLK, P1.1 output frequency ~ 800000/1000
//   
//           MSP430F123(2)
//         -----------------
//     /|\|              XIN|-  
//      | |                 |
//      --|RST          XOUT|-
//        |                 |
//        |             P1.1|-->TA0 SMCLK/1000
//
//  M.Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include <msp430x12x.h>

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  TACTL = TASSEL1 + TACLR;              // SMCLK, clear TAR
  CCTL0 = OUTMOD_4;                     // CCR0 toggle mode
  CCR0 = 500-1;
  P1DIR |= 0x02;                        // P1.1 output
  P1SEL |= 0x02;                        // P1.1 option select
  TACTL |= MC0;                         // Start Timer_a in upmode
 
  for (;;)                              
  {
    _BIS_SR(CPUOFF);                    // CPU off
    _NOP();                             // Required only for C-spy
  }
}
