//******************************************************************************
//  MSP-FET430P120 Demo - Timer_A Toggle P1.0, CCR0 upmode ISR, 32kHz ACLK 
//
//  Description; Toggle P1.0 using software and the TA_0 ISR. Timer_A is 
//  configured in an upmode, thus the the timer will overflow when TAR counts 
//  to CCR0. In this example, CCR0 is loaded with 1000.
//  Toggle rate = 32768/(2*1000) = 16.384
//  ACLK = TACLK = 32768, MCLK = SMCLK = DCO ~ 800k 
//  //*An external watch crystal on XIN XOUT is required for ACLK*//	  
//   
//
//           MSP430F123(2)
//         -----------------
//     /|\|              XIN|-  
//      | |                 | 32kHz
//      --|RST          XOUT|-
//        |                 |
//        |             P1.0|-->LED
//
//  M.Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include <msp430x12x.h>

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  TACTL = TASSEL0 + TACLR;              // ACLK, clear TAR
  CCTL0 = CCIE;                         // CCR0 interrupt enabled
  CCR0 = 1000;
  P1DIR |= 0x01;                        // P1.0 output
  TACTL |= MC0;                         // Start Timer_a in upmode
  _EINT();                              // Enable interrupts
 
  for (;;)                              
  {
    _BIS_SR(LPM3_bits);                 // Enter LPM3
    _NOP();                             // Required only for C-spy
  }
}

// Timer A0 interrupt service routine
void Timer_A (void) __interrupt[TIMERA0_VECTOR] 
{
  P1OUT ^= 0x01;                        // Toggle P1.0
}

