//******************************************************************************
//  MSP-FET430P120 Demo - Timer_A Toggle P1.0, CCR0 upmode ISR, DCO SMCLK 
//
//  Description; toggle P1.0 using using software and TA_0 ISR. Timer_A is 
//  configured in upmode, thus the timer will overflow when TAR counts to CCR0.  
//  In this example, CCR0 is loaded with 20000. 
//  ACLK = n/a, MCLK = SMCLK = TACLK = DCO ~ 800k 
//   
//           MSP430F123(2)
//         -----------------
//     /|\|              XIN|-  
//      | |                 |
//      --|RST          XOUT|-
//        |                 |
//        |             P1.0|-->LED
//
//  M.Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include <msp430x14x.h>

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  TACTL = TASSEL1 + TACLR;              // SMCLK, clear TAR
  CCTL0 = CCIE;                         // CCR0 interrupt enabled
  CCR0 = 20000;
  P1DIR |= 0x01;                        // P1.0 output
  TACTL |= MC0;                         // Start Timer_a in upmode
  _EINT();                              // Enable interrupts
 
  for (;;)                              
  {
    _BIS_SR(CPUOFF);                    // CPU off
    _NOP();                             // Required only for C-spy
  }
}

// Timer A0 interrupt service routine
void Timer_A (void) __interrupt[TIMERA0_VECTOR] 
{
  P1OUT ^= 0x01;                        // Toggle P1.0
}

