//******************************************************************************
//  MSP-FET430P120 Demo - ADC10 Sample A2/1/0, AVcc, Signle Sequence DTC DCO 
//
//  Description; Sample A1/A0/A3 as single sequence with reference to Avcc. 
//  Software sets ADC10SC to trigger sample sequuence. In Mainloop MSP430 waits
//  in LPM0 to save power until ADC10 conversion complete, ADC10_ISR(DTC) will 
//  force exit from any LPMx in Mainloop on reti. ADC10_ISR will force any LPMx
//  exit. ADC10 internal oscillator times sample period (16x) and conversion 
//  (13x). DTC transfers conversion code to RAM 200h - 206h. P1.0 set at start
//  of conversion burst, reset on completion.
//  //* MSP430F1232 or MSP430F1132 Device Required *//
//
//               MSP430F1232
//            -----------------
//        /|\|              XIN|-  
//         | |                 |
//         --|RST          XOUT|-
//           |                 |
//       >---|A3           P1.0|-->LED
//       >---|A2               |
//       >---|A0               |
//
//  M.Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include  <msp430x12x2.h>

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  ADC10CTL1 = INCH_2 + CONSEQ_1;        // A2/A1/A0, single sequence      
  ADC10CTL0 = ADC10SHT_2 + MSC + ADC10ON + ADC10IE;
  ADC10DTC1 = 0x03;                     // 3 conversions   
  ADC10AE |= 0x07;                      // P2.2,1,0 ADC option select 
  P1DIR |= 0x01;                        // Set P1.0 output
  
  for (;;)                              
  {
    ADC10CTL0 &= ~ENC;                  // 
    while ((ADC10CTL1 & BUSY) == BUSY); // ADC10 core must be inactive
    ADC10SA = 0x200;                    // Data buffer start
    P1OUT |= 0x01;                      // P1.0 = 1
    ADC10CTL0 |= ENC + ADC10SC;         // Sampling and conversion start
    _BIS_SR(CPUOFF + GIE);              // LPM0, ADC12 ISR will force exit
    P1OUT &= ~0x01;                     // P1.0 = 0
  }
}

// ADC10 interrupt service routine
void ADC10_ISR (void) __interrupt[ADC10_VECTOR] 
{
    _BIC_SR_IRQ(CPUOFF);                // Clear CPUOFF bit from 0(SR)
}
