//******************************************************************************
//  MSP-FET430P120 Demo - ADC10 Output Internal Vref on P2.4 and Osc. on P1.0 
//
//  Description; Output ADC10 internal VRef on P2.4, toggling between two 
//  avaialble options, 2.5v and 1.5v. ADC10OSC also output on P1.0. 
//  //*MSP430F1232 or MSP430F1132 Device Required*//
//
//               MSP430F1232
//            -----------------
//        /|\|              XIN|-  
//         | |                 |
//         --|RST          XOUT|-
//           |                 |
//     VRef<-|A4/P2.4      P1.0|--> ADC10OSC ~ 3.5MHz - 6.5MHz
//
//  M.Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include  <msp430x12x2.h>

void delay(void);                       // Software delay

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  ADC10CTL1 = CONSEQ_2;                 // Repeat single channel   
  ADC10CTL0 = REFOUT + REFON + MSC + ADC10ON;
  ADC10AE |= 0x10;                      // P2.4 ADC option select 
  P1DIR |= 0x01;                        // Set P1.0 output direction
  P1SEL |= 0x01;                        // Set P1.0 option select
  
  for (;;)                              
  {
    ADC10CTL0 &= ~ENC;                  // ADC10 disable
    ADC10CTL0 ^= REF2_5V;               // Toggle Vref 1.5/2.5V
    ADC10CTL0 |= ENC + ADC10SC;         // Sampling and conversion start
    delay();
    }
}

void delay(void)
{
  unsigned long i;
    for (i = 0x7FFFF; i > 0; i--);
}
  
