//******************************************************************************
//  MSP-FET430P120 Demo - ADC10 Sample A10 Temp Set P1.0 if temp > ~ 29c 
//
//  Description; A single sample is made on A10 with refernce to internal
//  1.5V Vref. Software sets ADC10SC to start sample and conversion - ADC10SC 
//  automatically cleared at EOC. (ADC10OSC/4)/64 determines sample time which
//  needs to be greater than 30us for temperature sensor. In Mainloop MSP430 
//  waits in LPM0 to save power until ADC10 conversion complete, ADC10_ISR will
//  force exit from LPM0 in Mainloop on reti. If A10 > 1088mv, P1.0 set, 
//  else reset. A10 ~ 1088mv or 02E7h with 1.5v reference very approximate 29c.
//  Temperature sensor offset and slope will vary from device to device per 
//  datasheet tolerence. 
//
//                MSP430F1232
//             -----------------
//         /|\|              XIN|-  
//          | |                 |
//          --|RST          XOUT|-
//            |                 |
//            |A10          P1.0|-->LED
//
//  M.Buccini
//  Texas Instruments, Inc
//  January 2002
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include  <msp430x12x2.h>

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;             // Stop WDT
  ADC10CTL1 = INCH_10+ADC10DIV_3;       // Temp Sensor ADC10CLK/4   
  ADC10CTL0 = SREF_1 + ADC10SHT_3 + REFON + ADC10ON + ADC10IE;
  P1DIR |= 0x01;                        // Set P1.0 to output direction
  
  for (;;)                              
  {
    ADC10CTL0 |= ENC + ADC10SC;         // Sampling and conversion start
    _BIS_SR(CPUOFF + GIE);              // LPM0 with interrupts enabled
    if (ADC10MEM < 0x2E7)               // 
    {
    P1OUT &= ~0x01;                     // Clear P1.0 LED off
    }
    else
    {
    P1OUT |= 0x01;                      // Set P1.0 LED on
    }
  }
}

// ADC10 interrupt service routine
void ADC10_ISR (void) __interrupt[ADC10_VECTOR] 
{
    _BIC_SR_IRQ(CPUOFF);                // Clear CPUOFF bit from 0(SR)
}
