//******************************************************************************
//  MSP-FET430P120 Demo - ADC10 Sample A0, AVcc 
//
//  Description; A single sample is made on A0 with reference to Avcc.  
//  Software sets ADC10SC to start sample and conversion - ADC10SC 
//  automatically cleared at EOC. ADC10 internal oscillator times sample (16x)
//  and conversion. ADC10BUSY flag is polled for EOC. Conversion code in 
//  ADC10MEM. 
//  //* MSP430F12x2 or MSP430F11x2 Device Required *//
//
//                MSP430F1232
//             -----------------
//         /|\|              XIN|-  
//          | |                 |
//          --|RST          XOUT|-
//            |                 |
//        >---|A0               |
//
//  M.Buccini
//  Texas Instruments, Inc
//  February
//  Built with IAR Embedded Workbench Version: 1.25A
//******************************************************************************

#include  <msp430x12x2.h>

void main(void)
{ 
  WDTCTL = WDTPW + WDTHOLD;                 // Stop WDT
  ADC10CTL0 = ADC10ON;                      // ADC10ON
  ADC10AE |= 0x01;                          // P2.0 ADC option select 
  
  for (;;)                                  
  {
    ADC10CTL0 |= ENC + ADC10SC;             // Sampling open
    while ((ADC10CTL1 & ADC10BUSY) == 1);   // ADC10BUSY?
  }
}
