// Copyright (c) 2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
////////////////////////////////////////////////////////////////////////////////
//
//                            Debug I/O Example
//
// Description
// -----------
// This example reading and writing of a file using CrossStudio's debug I/O
// library.
//
////////////////////////////////////////////////////////////////////////////////

#include <__cross_studio_io.h>

static void
writeTextFile(const char *filename)
{
  DEBUG_FILE *stream;
  stream = debug_fopen(filename, "wt");
  if (stream)
    {
      int i;
      for (i = 0; i < 10; ++i)
        debug_fprintf(stream, "Hello World %d\n", i);
      debug_fclose(stream);
    }
  else
    debug_printf("cannot open %s\n", filename);
}

static void
readTextFile(const char *filename)
{
  DEBUG_FILE *stream;
  stream = debug_fopen(filename, "rt");
  if (stream)
    {
      char buffer[32];
      while (debug_fgets(buffer, sizeof(buffer), stream))
        debug_printf("read: %s", buffer);
      debug_fclose(stream);
    }
  else
    debug_printf("cannot open %s\n", filename);
}

int
main(void)
{
  const char *filename = "debugio_example.txt";
  writeTextFile(filename);
  readTextFile(filename);
  debug_exit(0);
}
