#include <msp430x43x.h>
#include "vi322.h"

#define _A  (1<<0)   //      AAA
#define _B  (1<<1)   //     F   B
#define _C  (1<<2)   //     F   B
#define _D  (1<<3)   //      GGG
#define _E  (1<<4)   //     E   C
#define _F  (1<<5)   //     E   C
#define _G  (1<<6)   //      DDD
#define _DP (1<<7)

//  1 COM  11 3C   21 1A   31 3F 
//  2 -    12 3DP  22 1F   32 3G 
//  3 B-C  13 2E   23 1G   33 NC 
//  4 NC   14 2D   24 2B   34 NC 
//  5 NC   15 2C   25 2A   35 NC 
//  6 NC   16 2DP  26 2F   36 NC 
//  7 NC   17 1E   27 2G   37 ~ 
//  8 4DP  18 1D   28 L    38 @ 
//  9 3E   19 1C   29 3B   39 : 
// 10 3D   20 1B   30 3A   40 BAT 

static const unsigned char vi_322_digits[16] =
{
  _A | _B | _C | _D | _E | _F,   // 0
  _B | _C,                       // 1
  _A | _B | _D | _E | _G,        // 2
  _A | _B | _C | _D | _G,        // 3
  _B | _C | _F | _G,             // 4
  _A | _F | _G | _C | _D,        // 5
  _A | _F | _G | _C | _D | _E,   // 6
  _F | _A | _B | _C,                 // 7
  _A | _B | _C | _D | _E | _F | _G,  // 8
  _F | _A | _B | _G | _C | _D        //9
};

void
vi_322_show_digit(int digit, int pos)
{
  unsigned char c;
  char *p = LCDMEM + pos*4;
  if (pos == 2)
    p += 2;
  c = vi_322_digits[digit];
  p[0] = ((c & _A) << 0) | ((c & _B) << 3);
  p[1] = ((c & _C) >> 2) | ((c & _D) << 1);
  p[2] = ((c & _E) >> 4) | ((c & _F) >> 1);
  p[3] = p[3] & 0xf0 | ((c & _G) >> 6);
}

void
vi_322_segment_on(int segment)
{
  LCDMEM[segment >> 1] |= (segment & 1) ? 0x10 : 0x01;
}

void
vi_322_segment_off(int segment)
{
  LCDMEM[segment >> 1] &= (segment & 1) ? ~0x10 : ~0x01;
}

void
vi_322_segment_toggle(int segment)
{
  LCDMEM[segment >> 1] ^= (segment & 1) ? 0x10 : 0x01;
}

void
vi_322_blank_digit(int pos)
{
  char *p = LCDMEM + pos*4;
  if (pos == 2)
    p += 2;
  p[0] = 0;
  p[1] = 0;
  p[2] = 0;
  p[3] &= 0xf0;
}

void
vi_322_show_number(int i)
{
  if (i >= 1000)
    vi_322_segment_on(SEGMENT_LEADING_1);
  else
    vi_322_segment_off(SEGMENT_LEADING_1);
  
  if (i >= 100)
    vi_322_show_digit(i / 100 % 10, 2);
  else
    vi_322_blank_digit(2);
    
  if (i >= 10)
    vi_322_show_digit(i / 10 % 10, 1);
  else
    vi_322_blank_digit(1);

  vi_322_show_digit(i % 10, 0);
}


