// Rowley C Compiler, runtime support.
//
// Copyright (c) 2001, 2002 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef __string_H
#define __string_H

#include "__crossworks.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef __SIZE_T_DEFINED
#define __SIZE_T_DEFINED
typedef __SIZE_T size_t;
#endif

#ifndef NULL
#define NULL 0
#endif

void *memcpy(void *s1, const void *s2, size_t n);
void *memmove(void *s1, const void *s2, size_t n);
int memcmp(const void *s1, const void *s2, size_t n);
void *memchr(const void *s, int c, size_t n);
void *memset(void *, int, size_t);

char *strcpy(char *s1, const char *s2);
char *strncpy(char *s1, const char *s2, size_t n);
char *strcat(char *s1, const char *s2);
char *strncat(char *s1, const char *s2, size_t n);
int strcmp(const char *s1, const char *s2);
int strncmp(const char *s1, const char *s2, size_t n);
char *strchr(const char *s, int c);
size_t strcspn(const char *s1, const char *s2);
char *strpbrk(const char *s1, const char *s2);
char *strrchr(const char *s, int c);
size_t strspn(const char *s1, const char *s2);
char *strstr(const char *s1, const char *s2);
size_t strlen(const char *s);
char *strtok(char *s1, const char *s2);
char *strtok_r(char *s1, const char *s2, char **lasts);

#ifdef __MULTOS__
// Use compiler intrinsics __memcpy and __memmove in preference to regular ones
void *__memcpy(void *s1, const void *s2, size_t n);
#define memcpy(s1,s2,n) __memcpy((s1),(s2),(n))
void *__memmove(void *s1, const void *s2, size_t n);
#define memmove(s1,s2,n) __memmove((s1),(s2),(n))
#endif

#ifdef __cplusplus
}
#endif

#endif

