// Rowley C Compiler, runtime support.
//
// Copyright (c) 2001, 2002 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef __CTYPE_H
#define __CTYPE_H

// Get definition for __CODE
#include "__crossworks.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Internal table which classifies characters and EOF. */
extern __CODE const unsigned char __ctype[256];

#define __CTYPE_UPPER          0x01    /* upper case letter */
#define __CTYPE_LOWER          0x02    /* lower case letter */
#define __CTYPE_DIGIT          0x04    /* digit */
#define __CTYPE_SPACE          0x08    /* whitespace */
#define __CTYPE_PUNCT          0x10    /* punctuation character */
#define __CTYPE_CONTROL        0x20    /* control character */
#define __CTYPE_BLANK          0x40    /* space char */
#define __CTYPE_HEX            0x80    /* hexadecimal digit */

/* Function implementation. */
int isalpha(int __c);
int isupper(int __c);
int islower(int __c);
int isdigit(int __c);
int isxdigit(int __c);
int isspace(int __c);
int ispunct(int __c);
int isalnum(int __c);
int isprint(int __c);
int isgraph(int __c);
int iscntrl(int __c);
int toupper(int __c);
int tolower(int __c);

int isblank(int __c);  /* C99 */

/* Define __CTYPE_MACROS before including this file and you'll get the
   macro implementation of these functions.
*/

#ifdef __CTYPE_MACROS

/* Macro implementation.  If you wish to use functions, simply #undef these
   as described in the ISO standard.  We take advantage of the fact that
   an entry in the _ctype array for EOF, which is -1, is identical to
   that for entry 255, i.e. that __ctype[(unsigned char)EOF] == _ctype[255]. */
#define isalpha(c)     (__ctype[(c)+1] & (__CTYPE_UPPER | __CTYPE_LOWER))
#define isupper(c)     (__ctype[(c)+1] & __CTYPE_UPPER)
#define islower(c)     (__ctype[(c)+1] & __CTYPE_LOWER)
#define isdigit(c)     (__ctype[(c)+1] & __CTYPE_DIGIT)
#define isxdigit(c)    (__ctype[(c)+1] & __CTYPE_HEX)
#define isspace(c)     (__ctype[(c)+1] & __CTYPE_SPACE)
#define ispunct(c)     (__ctype[(c)+1] & __CTYPE_PUNCT)
#define isalnum(c)     (__ctype[(c)+1] & (__CTYPE_UPPER | __CTYPE_LOWER | __CTYPE_DIGIT))
#define isprint(c)     (__ctype[(c)+1] & (__CTYPE_BLANK | __CTYPE_PUNCT | __CTYPE_UPPER | __CTYPE_LOWER | __CTYPE_DIGIT))
#define isgraph(c)     (__ctype[(c)+1] & (__CTYPE_PUNCT | __CTYPE_ALPHA | __CTYPE_DIGIT))
#define iscntrl(c)     (__ctype[(c)+1] & __CTYPE_CONTROL)

#endif

#ifdef __cplusplus
}
#endif

#endif
