// Rowley MSP430 C Compiler, runtime support.
//
// Copyright (c) 2002, 2003, 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef __in430_H
#define __in430_H

#include <inmsp.h>

#define _SWPB(X) __swap_bytes(X)
#define _LSWPW(X) __swap_words(X)
#define _LSWPB(X) __swap_long_bytes(X)
#define _BIS_SR(X) __bis_SR_register(X)
#define _BIC_SR(X) __bic_SR_register(X)
#define _BIS_SR_IRQ(X) __bis_SR_register_on_exit(X)
#define _BIC_SR_IRQ(X) __bic_SR_register_on_exit(X)
#define _DINT()  __disable_interrupt()
#define _EINT()  __enable_interrupt()
#define _NOP() __no_operation()
#define _OPC(X) __insert_opcode(X)
#define _DADD16(X, Y) __bcd_add_short((X), (Y))
#define _DADD32(X, Y) __bcd_add_long((X), (Y))
#define _DADD64(X, Y) __bcd_add_long_long((X), (Y))
#define _DSUB16(X, Y) __bcd_subtract_short((X), (Y))
#define _DSUB32(X, Y) __bcd_subtract_long((X), (Y))
#define _DSUB64(X, Y) __bcd_subtract_long_long((X), (Y))
#define _DNEG16(X) __bcd_negate_short(X)
#define _DNEG32(X) __bcd_negate_long(X)
#define _DNEG64(X) __bcd_negate_long_long(X)

#pragma intrinsic(_H16)
unsigned _H16(unsigned long);

#pragma intrinsic(_L16)
unsigned _L16(unsigned long);

#pragma intrinsic(_H32)
unsigned long _H32(unsigned long long);

#pragma intrinsic(_L32)
unsigned long _L32(unsigned long long);

#pragma intrinsic(_HH16)
unsigned _HH16(unsigned long long);

#pragma intrinsic(_LL16)
unsigned _LL16(unsigned long long);

#endif
